import sys

def resi():
    # Generator koji cita jedan po jedan broj iz ulaza (štedi memoriju)
    def uzmi_brojeve():
        for linija in sys.stdin:
            # Cistimo zareze i delimo liniju na delove
            for token in linija.replace(',', ' ').split():
                yield int(token)

    brojevi = uzmi_brojeve()
    
    try:
        n = next(brojevi)
    except StopIteration:
        return

    # 1. Brojanje ponavljanja lokacija (da bismo znali koliko ljudi krece odatle)
    # Koristimo recnik direktno dok citamo, bez cuvanja svih tacaka u listi
    brojac_lokacija = {}
    for _ in range(n):
        try:
            x = next(brojevi)
            y = next(brojevi)
            par = (x, y)
            brojac_lokacija[par] = brojac_lokacija.get(par, 0) + 1
        except StopIteration:
            break

    # Pomocne strukture za grupisane sume: {kljuc: [suma_k, suma_k_kvadrat]}
    # Ovo zamenjuje cuvanje celih listi k1, k2, k3...
    h_grupe = {}  # E-W
    v_grupe = {}  # N-S
    d1_grupe = {} # N-E i S-W (x+y)
    d2_grupe = {} # N-W i S-E (y-x)

    for (x, y), k in brojac_lokacija.items():
        k_sq = k * k
        
        # Kljucevi za grupisanje
        kh = (y, x % 2)
        kv = (x, y % 2)
        kd1 = x + y
        kd2 = y - x
        
        # Ažuriranje suma za svaku grupu
        for d, kljuc in [(h_grupe, kh), (v_grupe, kv), (d1_grupe, kd1), (d2_grupe, kd2)]:
            if kljuc not in d:
                d[kljuc] = [0, 0]
            d[kljuc][0] += k
            d[kljuc][1] += k_sq

    ukupno = 0

    # 2. Racunanje po formuli: (Suma(k)^2 - Suma(k^2)) / 2
    # Horizontalni i Vertikalni susreti (1 pozdrav po paru lokacija)
    for s, s2 in h_grupe.values():
        ukupno += (s * s - s2) // 2
    for s, s2 in v_grupe.values():
        ukupno += (s * s - s2) // 2

    # Dijagonalni susreti (2 pozdrava po paru lokacija)
    # 2 * (s*s - s2) // 2  => s*s - s2
    for s, s2 in d1_grupe.values():
        ukupno += (s * s - s2)
    for s, s2 in d2_grupe.values():
        ukupno += (s * s - s2)

    sys.stdout.write(str(ukupno) + '\n')

if __name__ == "__main__":
    resi()